import PIL.Image
import os
import google.generativeai as genai
from pathlib import Path
from dotenv import load_dotenv
load_dotenv()  # take environment variables from .env.
genai.configure(api_key=os.environ["GEMINI_API_KEY"])

# Create the model
# See https://ai.google.dev/api/python/google/generativeai/GenerativeModel
generation_config = {
  "temperature": 1,
  "top_p": 0.95,
  "top_k": 64,
  "max_output_tokens": 8192,
  "response_mime_type": "text/plain",
}

video_file_name = "BigBuckBunny_320x180.mp4"

print(f"Subiendo archivo...")
video_file = genai.upload_file(path=video_file_name)
print(f"Carga completada: {video_file.uri}")

import time

while video_file.state.name == "PROCESSING":
    print('.', end='')
    time.sleep(10)
    video_file = genai.get_file(video_file.name)

if video_file.state.name == "FAILED":
  raise ValueError(video_file.state.name)

file = genai.get_file(name=video_file.name)
print(f"archivo recuperado '{file.display_name}' as: {video_file.uri}")
# Create the prompt.
prompt = "Describe este vídeo."

# Los modelos Gemini 1.5 son versátiles y funcionan con indicaciones multimodales.
model = genai.GenerativeModel(model_name="models/gemini-1.5-flash")

# Make the LLM request.
print("Haciendo solicitud  LLM...")
response = model.generate_content([video_file, prompt],
                                  request_options={"timeout": 600})
print(response.text)


