import PIL.Image
import os
import google.generativeai as genai
from pathlib import Path
from dotenv import load_dotenv
load_dotenv()  # take environment variables from .env.
genai.configure(api_key=os.environ["GEMINI_API_KEY"])

# Create the model
# See https://ai.google.dev/api/python/google/generativeai/GenerativeModel
generation_config = {
  "temperature": 1,
  "top_p": 0.95,
  "top_k": 64,
  "max_output_tokens": 8192,
  "response_mime_type": "text/plain",
}

model = genai.GenerativeModel(
  model_name="gemini-pro-vision",
  generation_config=generation_config,
  # safety_settings = Adjust safety settings
  # See https://ai.google.dev/gemini-api/docs/safety-settings
)

# para gestionar las imagenes usamos Pillow. Si estás replicando este cuaderno en tu propio ambiente deberás instalar esta librería. Usa pip install Pillow
img = PIL.Image.open('img.webp')
response = model.generate_content([
    "¿que hay en la foto? ¿Se asocia a algún país en particular?"
    , img], stream=True)
response.resolve()
print(response.text)