import os
import google.generativeai as genai
from pathlib import Path
from dotenv import load_dotenv
load_dotenv()  # take environment variables from .env.


genai.configure(api_key=os.environ["GEMINI_API_KEY"])

# Cambiamos a Gemini Pro
model = genai.GenerativeModel('gemini-pro')

# Iniciamos el chat sin ninguna historia previa
chat = model.start_chat(history=[])
response = chat.send_message("Vivo en Ponferrada. Describe brevemente mi ciudad")
print(response.text)
response = chat.send_message("¿Quién es el alcalde de mi ciudad")
print(response.text)




import trafilatura
def extraer_texto(url):
    # Descargar el contenido de la página web
    downloaded = trafilatura.fetch_url(url)
    
    # Verificar si se ha descargado correctamente
    if downloaded:
        # Extraer el texto del contenido descargado
        texto_extraido = trafilatura.extract(downloaded)
        return texto_extraido
    else:
        return None

# contexto
url = 'https://es.wikipedia.org/wiki/Ponferrada'

# Extraer el texto de la URL especificada
texto = extraer_texto(url)
response = chat.send_message(f"{texto}\n ¿Quién es el alcalde de mi ciudad")
print(response.text)

